(function() {
  var GuideGuide;

  GuideGuide = (function() {
    GuideGuide.prototype.capabilities = {
      artboardGuides: false
    };

    function GuideGuide() {
      this.charProperty = this.cTID('Prpr');
      this.charDocument = this.cTID('Dcmn');
      this.charOrdinal = this.cTID('Ordn');
      this.charTarget = this.cTID('Trgt');
      this.charGet = this.cTID('getd');
      this.charLayer = this.cTID('Lyr ');
      this.charSelect = this.cTID('slct');
      this.charNull = this.cTID('null');
      this.charMenu = this.cTID('Mn  ');
      this.charMenuItem = this.cTID('MnIt');
      this.charToggleGuides = this.cTID('Tgld');
      this.charMake = this.cTID('Mk  ');
      this.charNew = this.cTID('Nw  ');
      this.charPosition = this.cTID('Pstn');
      this.charPixel = this.cTID('#Pxl');
      this.charOrientation = this.cTID('Ornt');
      this.charGuide = this.cTID('Gd  ');
      this.charVertical = this.cTID('Vrtc');
      this.charHorizontal = this.cTID('Hrzn');
      this.charKind = this.cTID('Knd ');
      this.strNull = this.sTID('null');
      this.strRulerOriginH = this.sTID('rulerOriginH');
      this.strRulerOriginV = this.sTID('rulerOriginV');
      this.strArtboard = this.sTID('artboard');
      this.strArtboards = this.sTID('artboards');
      this.strArtboardRect = this.sTID('artboardRect');
      this.strList = this.sTID('list');
      this.strTop = this.sTID('top');
      this.strBottom = this.sTID('bottom');
      this.strLeft = this.sTID('left');
      this.strRight = this.sTID('right');
      this.strGuideTarget = this.sTID('guideTarget');
      this.strTargetSelectedArtboard = this.sTID('guideTargetSelectedArtboard');
      this.detectCapabilities();
    }

    GuideGuide.prototype.cTID = function(s) {
      return app.charIDToTypeID(s);
    };

    GuideGuide.prototype.sTID = function(s) {
      return app.stringIDToTypeID(s);
    };

    GuideGuide.prototype.detectCapabilities = function() {
      var n, version;
      version = (function() {
        var _i, _len, _ref, _results;
        _ref = app.version.split('.');
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          n = _ref[_i];
          _results.push(parseInt(n));
        }
        return _results;
      })();
      if (version[0] > 16 || (version[0] === 16 && version[1] > 0)) {
        return this.capabilities.artboardGuides = true;
      }
    };

    GuideGuide.prototype.isDocument = function(el) {
      return el.typename === 'Document';
    };

    GuideGuide.prototype.parent = function(el) {
      if (!this.isDocument(el.parent)) {
        return this.parent(el.parent);
      }
      if (el.typename === 'LayerSet') {
        return el;
      }
      return el.parent;
    };

    GuideGuide.prototype.activeArtboardIndex = function() {
      return this.parent(app.activeDocument.activeLayer).itemIndex;
    };

    GuideGuide.prototype.rulerOrigin = function() {
      return {
        x: this.getOffset('rulerOriginH'),
        y: this.getOffset('rulerOriginV')
      };
    };

    GuideGuide.prototype.countArtboards = function() {
      var abDesc, abDescList, desc, e, ref;
      try {
        ref = new ActionReference();
        ref.putProperty(this.charProperty, this.strArtboards);
        ref.putEnumerated(this.charDocument, this.charOrdinal, this.charTarget);
        desc = new ActionDescriptor();
        desc.putReference(this.strNull, ref);
        abDesc = executeAction(this.charGet, desc, DialogModes.NO).getObjectValue(this.strArtboards);
        abDescList = abDesc.getList(this.strList);
        return abDescList.count;
      } catch (_error) {
        e = _error;
        return 0;
      }
    };

    GuideGuide.prototype.getDocRect = function() {
      var doc, origin;
      origin = this.rulerOrigin();
      doc = app.activeDocument;
      return {
        width: doc.width.as('px'),
        height: doc.height.as('px'),
        offsetX: origin.x,
        offsetY: origin.y
      };
    };

    GuideGuide.prototype.getArtboardRect = function() {
      var desc, e, origin, rect, ref;
      try {
        origin = this.rulerOrigin();
        ref = new ActionReference();
        ref.putEnumerated(this.charLayer, this.charOrdinal, this.charTarget);
        ref.putIndex(this.charLayer, this.activeArtboardIndex());
        desc = new ActionDescriptor();
        desc.putReference(this.strNull, ref);
        rect = executeAction(this.charGet, desc, DialogModes.NO).getObjectValue(this.strArtboard).getObjectValue(this.strArtboardRect);
        return {
          width: rect.getInteger(this.strRight) - rect.getInteger(this.strLeft),
          height: rect.getInteger(this.strBottom) - rect.getInteger(this.strTop),
          offsetX: origin.x + rect.getInteger(this.strLeft),
          offsetY: origin.y + rect.getInteger(this.strTop)
        };
      } catch (_error) {
        e = _error;
        return this.getDocRect();
      }
    };

    GuideGuide.prototype.getRectInfo = function() {
      if (this.countArtboards() > 0) {
        return this.getArtboardRect();
      }
      return this.getDocRect();
    };

    GuideGuide.prototype.getSnap = function() {
      return true;
    };

    GuideGuide.prototype.getOffset = function(key) {
      var desc, origin, ref;
      ref = new ActionReference();
      origin = this.sTID(key);
      ref.putProperty(this.charProperty, origin);
      ref.putEnumerated(this.charDocument, this.charOrdinal, this.cTID("Trgt"));
      desc = executeActionGet(ref);
      if (desc.hasKey(origin)) {
        return (desc.getInteger(origin) / 65536) * -1;
      } else {
        return 0;
      }
    };

    GuideGuide.prototype.getBounds = function(bounds) {
      if (!bounds) {
        return null;
      }
      return {
        x1: parseInt(bounds[0]),
        x2: parseInt(bounds[2]),
        y1: parseInt(bounds[1]),
        y2: parseInt(bounds[3])
      };
    };

    GuideGuide.prototype.getGuides = function(remove) {
      var dir, guide, i, key, obj, _i, _len, _ref;
      if (remove == null) {
        remove = false;
      }
      obj = {};
      _ref = app.activeDocument.guides;
      for (i = _i = 0, _len = _ref.length; _i < _len; i = ++_i) {
        guide = _ref[i];
        dir = guide.direction.toString().split('.')[1].toLowerCase().charAt(0);
        key = "" + dir + ":" + (guide.coordinate.as('px'));
        obj[key] = {
          orientation: dir,
          location: guide.coordinate.as('px')
        };
        if (remove) {
          obj[key].guide = guide;
          obj[key].remove = function() {
            return this.guide.remove();
          };
        }
      }
      return obj;
    };

    GuideGuide.prototype.toggleGuides = function() {
      var desc, ref;
      desc = new ActionDescriptor();
      ref = new ActionReference();
      ref.putEnumerated(this.charMenu, this.charMenuItem, this.charToggleGuides);
      desc.putReference(this.charNull, ref);
      return executeAction(this.charSelect, desc, DialogModes.NO);
    };

    GuideGuide.prototype.getDocumentRulerUnits = function() {
      if (!(app.documents.length > 0)) {
        return '';
      }
      return this.friendlyUnits(app.preferences.rulerUnits);
    };

    GuideGuide.prototype.getAppInfo = function() {
      return JSON.stringify({
        snap: this.getSnap()
      });
    };

    GuideGuide.prototype.getDocumentInfo = function() {
      var doc, error, info, rect, units;
      if (!(app.documents.length > 0)) {
        return JSON.stringify({});
      }
      doc = app.activeDocument;
      units = this.before();
      rect = this.getRectInfo();
      info = {
        ruler: this.friendlyUnits(units),
        resolution: doc.resolution,
        offsetX: rect.offsetX,
        offsetY: rect.offsetY,
        width: rect.width,
        height: rect.height,
        guides: this.getGuides(),
        bounds: null
      };
      try {
        info.bounds = this.getBounds(doc.selection.bounds);
        info.offsetX = info.bounds.x1;
        info.offsetY = info.bounds.y1;
        info.width = info.bounds.x2 - info.bounds.x1;
        info.height = info.bounds.y2 - info.bounds.y1;
      } catch (_error) {
        error = _error;
      }
      this.after(units);
      return JSON.stringify(info);
    };

    GuideGuide.prototype.execAndLog = function(label, method, data) {
      var fn;
      if (data && typeof data === 'object') {
        data = JSON.stringify(data);
      }
      fn = "$.GuideGuide." + method + "(" + (data ? '\'' + data + '\'' : '') + ")";
      return app.activeDocument.suspendHistory(label, fn);
    };

    GuideGuide.prototype.addGuides = function(guides) {
      this.execAndLog('GuideGuide!', 'SUSPENDED_addGuides', guides);
      return null;
    };

    GuideGuide.prototype.SUSPENDED_addGuides = function(guides) {
      var artboardAdjust, desc1, desc2, guide, idOrientation, origin, rect, ref1, ref2, units, _i, _len;
      guides = JSON.parse(guides);
      units = this.before();
      origin = this.rulerOrigin();
      for (_i = 0, _len = guides.length; _i < _len; _i++) {
        guide = guides[_i];
        desc1 = new ActionDescriptor();
        desc2 = new ActionDescriptor();
        artboardAdjust = 0;
        if (this.capabilities.artboardGuides) {
          rect = this.getArtboardRect();
          artboardAdjust = guide.orientation === 'v' ? rect.offsetX : rect.offsetY;
        }
        desc2.putUnitDouble(this.charPosition, this.charPixel, guide.location - artboardAdjust);
        idOrientation = guide.orientation === 'v' ? this.charVertical : this.charHorizontal;
        desc2.putEnumerated(this.charOrientation, this.charOrientation, idOrientation);
        try {
          ref1 = new ActionReference();
          ref2 = new ActionReference();
          desc2.putEnumerated(this.charKind, this.charKind, this.charDocument);
          ref1.putIdentifier(this.charDocument, 199);
          ref1.putIndex(this.charGuide, 3);
          desc2.putReference(this.charNull, ref1);
          desc1.putObject(this.charNew, this.charGuide, desc2);
          ref2.putClass(this.charGuide);
          desc1.putReference(this.charNull, ref2);
          desc1.putEnumerated(this.strGuideTarget, this.strGuideTarget, this.strTargetSelectedArtboard);
        } catch (_error) {
          desc1.putObject(this.charNew, this.charGuide, desc2);
        }
        executeAction(this.charMake, desc1, DialogModes.NO);
      }
      return this.after(units);
    };

    GuideGuide.prototype.clearGuides = function(ids) {
      this.execAndLog('Clear guides', 'SUSPENDED_clearGuides', ids);
      return null;
    };

    GuideGuide.prototype.SUSPENDED_clearGuides = function(ids) {
      var guides, id, msg, _i, _len, _results;
      msg = {
        msg: "Started with " + ids,
        error: ""
      };
      if (ids == null) {
        app.activeDocument.guides.removeAll();
        return null;
      }
      ids = JSON.parse(ids);
      guides = this.getGuides(true);
      _results = [];
      for (_i = 0, _len = ids.length; _i < _len; _i++) {
        id = ids[_i];
        if (guides[id]) {
          _results.push(guides[id].remove());
        }
      }
      return _results;
    };

    GuideGuide.prototype.friendlyUnits = function(units) {
      switch (units) {
        case Units.CM:
          return "cm";
        case Units.INCHES:
          return "in";
        case Units.MM:
          return "mm";
        case Units.PERCENT:
          return "%";
        case Units.PICAS:
          return "picas";
        case Units.POINTS:
          return "points";
        default:
          return "px";
      }
    };

    GuideGuide.prototype.before = function() {
      var units;
      units = app.preferences.rulerUnits;
      app.preferences.rulerUnits = Units.PIXELS;
      return units;
    };

    GuideGuide.prototype.after = function(units) {
      return app.preferences.rulerUnits = units;
    };

    return GuideGuide;

  })();

  $.GuideGuide = new GuideGuide();

  "object"!=typeof JSON&&(JSON={}),function(){"use strict"
function f(t){return 10>t?"0"+t:t}function quote(t){return escapable.lastIndex=0,escapable.test(t)?'"'+t.replace(escapable,function(t){var e=meta[t]
return"string"==typeof e?e:"\\u"+("0000"+t.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+t+'"'}function str(t,e){var r,n,o,f,u,p=gap,i=e[t]
switch(i&&"object"==typeof i&&"function"==typeof i.toJSON&&(i=i.toJSON(t)),"function"==typeof rep&&(i=rep.call(e,t,i)),typeof i){case"string":return quote(i)
case"number":return isFinite(i)?i+"":"null"
case"boolean":case"null":return i+""
case"object":if(!i)return"null"
if(gap+=indent,u=[],"[object Array]"===Object.prototype.toString.apply(i)){for(f=i.length,r=0;f>r;r+=1)u[r]=str(r,i)||"null"
return o=0===u.length?"[]":gap?"[\n"+gap+u.join(",\n"+gap)+"\n"+p+"]":"["+u.join(",")+"]",gap=p,o}if(rep&&"object"==typeof rep)for(f=rep.length,r=0;f>r;r+=1)"string"==typeof rep[r]&&(n=rep[r],o=str(n,i),o&&u.push(quote(n)+(gap?": ":":")+o))
else for(n in i)Object.prototype.hasOwnProperty.call(i,n)&&(o=str(n,i),o&&u.push(quote(n)+(gap?": ":":")+o))
return o=0===u.length?"{}":gap?"{\n"+gap+u.join(",\n"+gap)+"\n"+p+"}":"{"+u.join(",")+"}",gap=p,o}}"function"!=typeof Date.prototype.toJSON&&(Date.prototype.toJSON=function(){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null},String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(){return this.valueOf()})
var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","  ":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep
"function"!=typeof JSON.stringify&&(JSON.stringify=function(t,e,r){var n
if(gap="",indent="","number"==typeof r)for(n=0;r>n;n+=1)indent+=" "
else"string"==typeof r&&(indent=r)
if(rep=e,e&&"function"!=typeof e&&("object"!=typeof e||"number"!=typeof e.length))throw Error("JSON.stringify")
return str("",{"":t})}),"function"!=typeof JSON.parse&&(JSON.parse=function(text,reviver){function walk(t,e){var r,n,o=t[e]
if(o&&"object"==typeof o)for(r in o)Object.prototype.hasOwnProperty.call(o,r)&&(n=walk(o,r),void 0!==n?o[r]=n:delete o[r])
return reviver.call(t,e,o)}var j
if(text+="",cx.lastIndex=0,cx.test(text)&&(text=text.replace(cx,function(t){return"\\u"+("0000"+t.charCodeAt(0).toString(16)).slice(-4)})),/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,"")))return j=eval("("+text+")"),"function"==typeof reviver?walk({"":j},""):j
throw new SyntaxError("JSON.parse")})}();

}).call(this);
